require( "scripts/style.lua" );



TitleFont = {
  standardFont,
  32,
  RedColor
};

CustomerTypeFont = {
	standardFont,
	17,
	RedColor
};

CustomerTypeStyle = {
	parent = DefaultStyle,
	font = CustomerTypeFont,
	w = 200,
	h = 200,
	flags = kHAlignLeft + kVAlignTop,
};

CustomerDescripFont = {
	standardFont,
	13,
	BorderColor
};

CustomerDescripStyle = {
	parent = DefaultStyle,
	font = CustomerDescripFont,
	w = 200,
	h = 200,
	flags = kHAlignLeft + kVAlignTop,
};


MakeDialog
{
	Bitmap
	{
		name="backgroundimage",
		image="backgrounds/fullscreendialog",
		x=0,y=0,w=kMax,h=kMax,
		
		Text
		{
			font = TitleFont,
			name = "title",
			x=0,y=30,w=kMax,h=80,
			flags = kHAlignCenter + kVAlignTop,
			label = "customertypes"
		};
		

		SetStyle(CustomerTypeStyle);
		
		Text
		{
			label = "celebrity",
			x = 212,
			y = 88,
		};
		
		Text
		{
			label = "family",
			x = 496,
			y = 88,
		};
		
		Text
		{
			label = "foodcritic",
			x = 212,
			y = 241,
		};
		
		Text
		{
			label = "teenager",
			x = 480,
			y = 241,
		};
		
		
		Text
		{
			label = "hungryman",
			x = 212,
			y = 381,
		};
		
		Text
		{
			label = "tourists",
			x = 480,
			y = 381,
		};
		
		SetStyle(DefaultStyle);
		
		SetStyle(CustomerDescripStyle);
		
		Text
		{
			label = "celebrity_descrip",
			x = 212,
			y = 108,
		};
		
		Text
		{
			label = "family_descrip",
			x = 496,
			y = 108,
		};
		
		Text
		{
			label = "foodcritic_descrip",
			x = 212,
			y = 261,
		};
		
		Text
		{
			label = "teenager_descrip",
			x = 480,
			y = 261,
		};
		
		
		
		Text
		{
			label = "hungryman_descrip",
			x = 212,
			y = 401,
		};
		
		Text
		{
			label = "tourist_descrip",
			x = 480,
			y = 401,
		};
		
		SetStyle(DefaultStyle);
		
		CustomerAnimationWindow
		{
			x = 183,
			y = 140,
			anim = "customers/default/celebrity_male/anim.anm",
			color = 1,
			script = "Stand",
		};
		
		CustomerAnimationWindow
		{
			x = 419,
			y = 155,
			anim = "customers/default/kid_male/anim.anm",
			color = 2,
			script = "Stand",
		};
		
		CustomerAnimationWindow
		{
			x = 446,
			y = 145,
			anim = "customers/default/mom_female/anim.anm",
			color = 3,
			script = "Stand",
		};
		
		CustomerAnimationWindow
		{
			x = 476,
			y = 138,
			anim = "customers/default/dad_male/anim.anm",
			color = 4,
			script = "Stand",
		};
		
		CustomerAnimationWindow
		{
			x = 183,
			y = 290,
			anim = "customers/default/foodcritic_female/anim.anm",
			color = 0,
			script = "Stand",
		};
		
		CustomerAnimationWindow
		{
			x = 418,
			y = 290,
			anim = "customers/default/teen_female/anim.anm",
			color = 2,
			script = "Stand",
		};
		
		CustomerAnimationWindow
		{
			x = 450,
			y = 290,
			anim = "customers/default/teen_male/anim.anm",
			color = 3,
			script = "Stand",
		};
		

		

		

		CustomerAnimationWindow
		{
			x = 178,
			y = 434,
			anim = "customers/default/hungryman_male/anim.anm",
			color = 3,
			script = "Stand",
		};
		

		CustomerAnimationWindow
		{
			x = 418,
			y = 434,
			anim = "customers/default/tourist_male/anim.anm",
			color = 2,
			script = "Stand",
		};
		
		CustomerAnimationWindow
		{
			x = 450,
			y = 434,
			anim = "customers/default/tourist_female/anim.anm",
			color = 1,
			script = "Stand",
		};
		

		
		SetStyle(SmallestButtonStyle);
		Button
		{
			x=kCenter,
			y=540,
			name="back",
			label="back",
			command=
				function()
					ActivateHelpClock(false);
					PopModal("scripts/help5.lua");
				end
		},
		SetStyle(HelpArrowStyle);
		
		
		Button
		{
			x=45,
			y=530,
			name="right",
			command=
				function()
					SwapToModalSetName("scripts/help4.lua");
				end
		},
			
	},
	
};

ActivateHelpClock(true);